#version 330

uniform mat4 worldview;
uniform mat4 worldviewproj;
uniform mat4 invworldview;
uniform vec4 blend;
uniform vec4 edges;

in vec4 vertex;
in vec4 uv0;

void main()
{
	vec4 p = vec4(vertex.xy, invworldview[3][2], 1.0);
	vec3 dv = (worldview*p).xyz;
	float d2 = dot(dv, dv);
	float d = sqrt(d2);
	float f;
	if(uv0.x == 1.0) {
		f = edges.x;
	} else if(uv0.y == 1.0) {
		f = edges.y;
	} else if(uv0.x == 0.0) {
		f = edges.z;
	} else if(uv0.y == 0.0) {
		f = edges.w;
	} else {
		f = clamp((d - blend.x)*blend.z, 0.0, 1.0);
	}
	vec4 v0 = vec4(mix(vertex.xyz, vertex.xyw, f), 1.0);
	gl_Position = worldviewproj*v0;
}
